import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import * as PoliciesAPI from "../policies.js";
import { SplitTunnelExcludesSinglePage } from "../policies.js";
export declare class Excludes extends APIResource {
    /**
     * Sets the list of routes excluded from the WARP client's tunnel for a specific
     * device settings profile.
     */
    update(policyId: string, params: ExcludeUpdateParams, options?: Core.RequestOptions): Core.PagePromise<SplitTunnelExcludesSinglePage, PoliciesAPI.SplitTunnelExclude>;
    /**
     * Fetches the list of routes excluded from the WARP client's tunnel for a specific
     * device settings profile.
     */
    get(policyId: string, params: ExcludeGetParams, options?: Core.RequestOptions): Core.PagePromise<SplitTunnelExcludesSinglePage, PoliciesAPI.SplitTunnelExclude>;
}
export interface ExcludeUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<PoliciesAPI.SplitTunnelExcludeParam>;
}
export interface ExcludeGetParams {
    account_id: string;
}
export declare namespace Excludes {
    export { type ExcludeUpdateParams as ExcludeUpdateParams, type ExcludeGetParams as ExcludeGetParams };
}
export { SplitTunnelExcludesSinglePage };
//# sourceMappingURL=excludes.d.ts.map