// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
import { SplitTunnelExcludesSinglePage } from "../policies.mjs";
export class Excludes extends APIResource {
    /**
     * Sets the list of routes excluded from the WARP client's tunnel for a specific
     * device settings profile.
     */
    update(policyId, params, options) {
        const { account_id, body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/${policyId}/exclude`, SplitTunnelExcludesSinglePage, { body: body, method: 'put', ...options });
    }
    /**
     * Fetches the list of routes excluded from the WARP client's tunnel for a specific
     * device settings profile.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/${policyId}/exclude`, SplitTunnelExcludesSinglePage, options);
    }
}
export { SplitTunnelExcludesSinglePage };
//# sourceMappingURL=excludes.mjs.map