// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
import { FallbackDomainsSinglePage } from "../policies.mjs";
export class FallbackDomains extends APIResource {
    /**
     * Sets the list of domains to bypass Gateway DNS resolution. These domains will
     * use the specified local DNS resolver instead. This will only apply to the
     * specified device settings profile.
     */
    update(policyId, params, options) {
        const { account_id, domains } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/${policyId}/fallback_domains`, FallbackDomainsSinglePage, { body: domains, method: 'put', ...options });
    }
    /**
     * Fetches the list of domains to bypass Gateway DNS resolution from a specified
     * device settings profile. These domains will use the specified local DNS resolver
     * instead.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/${policyId}/fallback_domains`, FallbackDomainsSinglePage, options);
    }
}
export { FallbackDomainsSinglePage };
//# sourceMappingURL=fallback-domains.mjs.map