import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
export declare class Certificates extends APIResource {
    /**
     * Enable Zero Trust Clients to provision a certificate, containing a x509 subject,
     * and referenced by Access device posture policies when the client visits MTLS
     * protected domains. This facilitates device posture without a WARP session.
     */
    edit(params: CertificateEditParams, options?: Core.RequestOptions): Core.APIPromise<CertificateEditResponse | null>;
    /**
     * Fetches device certificate provisioning
     */
    get(params: CertificateGetParams, options?: Core.RequestOptions): Core.APIPromise<CertificateGetResponse | null>;
}
export type CertificateEditResponse = unknown | string;
export type CertificateGetResponse = unknown | string;
export interface CertificateEditParams {
    /**
     * Path param:
     */
    zone_id: string;
    /**
     * Body param: The current status of the device policy certificate provisioning
     * feature for WARP clients.
     */
    enabled: boolean;
}
export interface CertificateGetParams {
    zone_id: string;
}
export declare namespace Certificates {
    export { type CertificateEditResponse as CertificateEditResponse, type CertificateGetResponse as CertificateGetResponse, type CertificateEditParams as CertificateEditParams, type CertificateGetParams as CertificateGetParams, };
}
//# sourceMappingURL=certificates.d.ts.map