import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import * as PoliciesAPI from "../policies.js";
import { FallbackDomainsSinglePage } from "../policies.js";
export declare class FallbackDomains extends APIResource {
    /**
     * Sets the list of domains to bypass Gateway DNS resolution. These domains will
     * use the specified local DNS resolver instead.
     */
    update(params: FallbackDomainUpdateParams, options?: Core.RequestOptions): Core.PagePromise<FallbackDomainsSinglePage, PoliciesAPI.FallbackDomain>;
    /**
     * Fetches a list of domains to bypass Gateway DNS resolution. These domains will
     * use the specified local DNS resolver instead.
     */
    get(params: FallbackDomainGetParams, options?: Core.RequestOptions): Core.PagePromise<FallbackDomainsSinglePage, PoliciesAPI.FallbackDomain>;
}
export interface FallbackDomainUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    domains: Array<PoliciesAPI.FallbackDomainParam>;
}
export interface FallbackDomainGetParams {
    account_id: string;
}
export declare namespace FallbackDomains {
    export { type FallbackDomainUpdateParams as FallbackDomainUpdateParams, type FallbackDomainGetParams as FallbackDomainGetParams, };
}
export { FallbackDomainsSinglePage };
//# sourceMappingURL=fallback-domains.d.ts.map