import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import * as PoliciesAPI from "../policies.js";
import { SplitTunnelIncludesSinglePage } from "../policies.js";
export declare class Includes extends APIResource {
    /**
     * Sets the list of routes included in the WARP client's tunnel.
     */
    update(params: IncludeUpdateParams, options?: Core.RequestOptions): Core.PagePromise<SplitTunnelIncludesSinglePage, PoliciesAPI.SplitTunnelInclude>;
    /**
     * Fetches the list of routes included in the WARP client's tunnel.
     */
    get(params: IncludeGetParams, options?: Core.RequestOptions): Core.PagePromise<SplitTunnelIncludesSinglePage, PoliciesAPI.SplitTunnelInclude>;
}
export interface IncludeUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<PoliciesAPI.SplitTunnelIncludeParam>;
}
export interface IncludeGetParams {
    account_id: string;
}
export declare namespace Includes {
    export { type IncludeUpdateParams as IncludeUpdateParams, type IncludeGetParams as IncludeGetParams };
}
export { SplitTunnelIncludesSinglePage };
//# sourceMappingURL=includes.d.ts.map