"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplitTunnelIncludesSinglePage = exports.Includes = void 0;
const resource_1 = require("../../../../../resource.js");
const policies_1 = require("../policies.js");
Object.defineProperty(exports, "SplitTunnelIncludesSinglePage", { enumerable: true, get: function () { return policies_1.SplitTunnelIncludesSinglePage; } });
class Includes extends resource_1.APIResource {
    /**
     * Sets the list of routes included in the WARP client's tunnel.
     */
    update(params, options) {
        const { account_id, body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/include`, policies_1.SplitTunnelIncludesSinglePage, { body: body, method: 'put', ...options });
    }
    /**
     * Fetches the list of routes included in the WARP client's tunnel.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/include`, policies_1.SplitTunnelIncludesSinglePage, options);
    }
}
exports.Includes = Includes;
//# sourceMappingURL=includes.js.map