"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationsSinglePage = exports.Integrations = void 0;
const resource_1 = require("../../../../resource.js");
const pagination_1 = require("../../../../pagination.js");
class Integrations extends resource_1.APIResource {
    /**
     * Create a new device posture integration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/posture/integration`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the list of device posture integrations for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/posture/integration`, IntegrationsSinglePage, options);
    }
    /**
     * Delete a configured device posture integration.
     */
    delete(integrationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured device posture integration.
     */
    edit(integrationId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches details for a single device posture integration.
     */
    get(integrationId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Integrations = Integrations;
class IntegrationsSinglePage extends pagination_1.SinglePage {
}
exports.IntegrationsSinglePage = IntegrationsSinglePage;
Integrations.IntegrationsSinglePage = IntegrationsSinglePage;
//# sourceMappingURL=integrations.js.map