// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Integrations extends APIResource {
    /**
     * Create a new device posture integration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/posture/integration`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the list of device posture integrations for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/posture/integration`, IntegrationsSinglePage, options);
    }
    /**
     * Delete a configured device posture integration.
     */
    delete(integrationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured device posture integration.
     */
    edit(integrationId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches details for a single device posture integration.
     */
    get(integrationId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/posture/integration/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class IntegrationsSinglePage extends SinglePage {
}
Integrations.IntegrationsSinglePage = IntegrationsSinglePage;
//# sourceMappingURL=integrations.mjs.map