// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Settings extends APIResource {
    /**
     * Updates the current device settings for a Zero Trust account.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/devices/settings`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Describes the current device settings for a Zero Trust account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/settings`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Patches the current device settings for a Zero Trust account.
     */
    edit(params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/devices/settings`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=settings.mjs.map