"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColoListResponsesSinglePage = exports.Colos = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Colos extends resource_1.APIResource {
    /**
     * List Cloudflare colos that account's devices were connected to during a time
     * period, sorted by usage starting from the most used colo. Colos without traffic
     * are also returned and sorted alphabetically.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dex/colos`, ColoListResponsesSinglePage, {
            query,
            ...options,
        });
    }
}
exports.Colos = Colos;
class ColoListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.ColoListResponsesSinglePage = ColoListResponsesSinglePage;
Colos.ColoListResponsesSinglePage = ColoListResponsesSinglePage;
//# sourceMappingURL=colos.js.map