// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Colos extends APIResource {
    /**
     * List Cloudflare colos that account's devices were connected to during a time
     * period, sorted by usage starting from the most used colo. Colos without traffic
     * are also returned and sorted alphabetically.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dex/colos`, ColoListResponsesSinglePage, {
            query,
            ...options,
        });
    }
}
export class ColoListResponsesSinglePage extends SinglePage {
}
Colos.ColoListResponsesSinglePage = ColoListResponsesSinglePage;
//# sourceMappingURL=colos.mjs.map