"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Downloads = void 0;
const resource_1 = require("../../../../resource.js");
class Downloads extends resource_1.APIResource {
    /**
     * Downloads artifacts for an executed command. Bulk downloads are not supported
     */
    get(commandId, filename, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dex/commands/${commandId}/downloads/${filename}`, {
            ...options,
            headers: { Accept: 'application/zip', ...options?.headers },
            __binaryResponse: true,
        });
    }
}
exports.Downloads = Downloads;
//# sourceMappingURL=downloads.js.map