// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as DevicesAPI from "./devices.mjs";
import { DeviceListResponsesV4PagePaginationArray, Devices, } from "./devices.mjs";
export class FleetStatus extends APIResource {
    constructor() {
        super(...arguments);
        this.devices = new DevicesAPI.Devices(this._client);
    }
    /**
     * List details for live (up to 60 minutes) devices using WARP
     */
    live(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/dex/fleet-status/live`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List details for devices using WARP, up to 7 days
     */
    overTime(params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/dex/fleet-status/over-time`, {
            query,
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
}
FleetStatus.Devices = Devices;
FleetStatus.DeviceListResponsesV4PagePaginationArray = DeviceListResponsesV4PagePaginationArray;
//# sourceMappingURL=fleet-status.mjs.map