"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TracerouteTests = void 0;
const resource_1 = require("../../../resource.js");
class TracerouteTests extends resource_1.APIResource {
    /**
     * Get test details and aggregate performance metrics for an traceroute test for a
     * given time period between 1 hour and 7 days.
     */
    get(testId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/dex/traceroute-tests/${testId}`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a breakdown of metrics by hop for individual traceroute test runs
     */
    networkPath(testId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/dex/traceroute-tests/${testId}/network-path`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get percentiles for a traceroute test for a given time period between 1 hour and
     * 7 days.
     */
    percentiles(testId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/dex/traceroute-tests/${testId}/percentiles`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.TracerouteTests = TracerouteTests;
//# sourceMappingURL=traceroute-tests.js.map