// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as UploadAPI from "./upload.mjs";
import { Upload as UploadAPIUpload } from "./upload.mjs";
import * as VersionsAPI from "./versions/versions.mjs";
import { VersionCreateResponsesSinglePage, Versions, } from "./versions/versions.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Datasets extends APIResource {
    constructor() {
        super(...arguments);
        this.upload = new UploadAPI.Upload(this._client);
        this.versions = new VersionsAPI.Versions(this._client);
    }
    /**
     * Create a new dataset
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dlp/datasets`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update details about a dataset
     */
    update(datasetId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/datasets/${datasetId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch all datasets
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dlp/datasets`, DatasetsSinglePage, options);
    }
    /**
     * This deletes all versions of the dataset.
     */
    delete(datasetId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dlp/datasets/${datasetId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Fetch a specific dataset
     */
    get(datasetId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/datasets/${datasetId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DatasetsSinglePage extends SinglePage {
}
Datasets.DatasetsSinglePage = DatasetsSinglePage;
Datasets.Upload = UploadAPIUpload;
Datasets.Versions = Versions;
Datasets.VersionCreateResponsesSinglePage = VersionCreateResponsesSinglePage;
//# sourceMappingURL=datasets.mjs.map