"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Entries = void 0;
const resource_1 = require("../../../../../resource.js");
class Entries extends resource_1.APIResource {
    /**
     * This is used for multi-column EDMv2 datasets. The EDMv2 format can only be
     * created in the Cloudflare dashboard.
     */
    create(datasetId, version, entryId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/dlp/datasets/${datasetId}/versions/${version}/entries/${entryId}`, {
            body: body,
            ...options,
            headers: { 'Content-Type': 'application/octet-stream', ...options?.headers },
            __binaryRequest: true,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Entries = Entries;
//# sourceMappingURL=entries.js.map