import { APIResource } from "../../../resource.js";
import * as EntriesAPI from "./entries.js";
import { Entries, EntryCreateParams, EntryCreateResponse, EntryDeleteParams, EntryDeleteResponse, EntryGetParams, EntryGetResponse, EntryListParams, EntryListResponse, EntryListResponsesSinglePage, EntryUpdateParams, EntryUpdateResponse } from "./entries.js";
import * as LimitsAPI from "./limits.js";
import { LimitListParams, LimitListResponse, Limits } from "./limits.js";
import * as PatternsAPI from "./patterns.js";
import { PatternValidateParams, PatternValidateResponse, Patterns } from "./patterns.js";
import * as PayloadLogsAPI from "./payload-logs.js";
import { PayloadLogGetParams, PayloadLogGetResponse, PayloadLogUpdateParams, PayloadLogUpdateResponse, PayloadLogs } from "./payload-logs.js";
import * as DatasetsAPI from "./datasets/datasets.js";
import { Dataset, DatasetArray, DatasetCreateParams, DatasetCreation, DatasetDeleteParams, DatasetGetParams, DatasetListParams, DatasetUpdateParams, Datasets, DatasetsSinglePage } from "./datasets/datasets.js";
import * as EmailAPI from "./email/email.js";
import { Email } from "./email/email.js";
import * as ProfilesAPI from "./profiles/profiles.js";
import { ContextAwareness, Profile, ProfileGetParams, ProfileListParams, Profiles, ProfilesSinglePage, SkipConfiguration } from "./profiles/profiles.js";
export declare class DLP extends APIResource {
    datasets: DatasetsAPI.Datasets;
    patterns: PatternsAPI.Patterns;
    payloadLogs: PayloadLogsAPI.PayloadLogs;
    email: EmailAPI.Email;
    profiles: ProfilesAPI.Profiles;
    limits: LimitsAPI.Limits;
    entries: EntriesAPI.Entries;
}
export declare namespace DLP {
    export { Datasets as Datasets, type Dataset as Dataset, type DatasetArray as DatasetArray, type DatasetCreation as DatasetCreation, DatasetsSinglePage as DatasetsSinglePage, type DatasetCreateParams as DatasetCreateParams, type DatasetUpdateParams as DatasetUpdateParams, type DatasetListParams as DatasetListParams, type DatasetDeleteParams as DatasetDeleteParams, type DatasetGetParams as DatasetGetParams, };
    export { Patterns as Patterns, type PatternValidateResponse as PatternValidateResponse, type PatternValidateParams as PatternValidateParams, };
    export { PayloadLogs as PayloadLogs, type PayloadLogUpdateResponse as PayloadLogUpdateResponse, type PayloadLogGetResponse as PayloadLogGetResponse, type PayloadLogUpdateParams as PayloadLogUpdateParams, type PayloadLogGetParams as PayloadLogGetParams, };
    export { Email as Email };
    export { Profiles as Profiles, type ContextAwareness as ContextAwareness, type Profile as Profile, type SkipConfiguration as SkipConfiguration, ProfilesSinglePage as ProfilesSinglePage, type ProfileListParams as ProfileListParams, type ProfileGetParams as ProfileGetParams, };
    export { Limits as Limits, type LimitListResponse as LimitListResponse, type LimitListParams as LimitListParams, };
    export { Entries as Entries, type EntryCreateResponse as EntryCreateResponse, type EntryUpdateResponse as EntryUpdateResponse, type EntryListResponse as EntryListResponse, type EntryDeleteResponse as EntryDeleteResponse, type EntryGetResponse as EntryGetResponse, EntryListResponsesSinglePage as EntryListResponsesSinglePage, type EntryCreateParams as EntryCreateParams, type EntryUpdateParams as EntryUpdateParams, type EntryListParams as EntryListParams, type EntryDeleteParams as EntryDeleteParams, type EntryGetParams as EntryGetParams, };
}
//# sourceMappingURL=dlp.d.ts.map