// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Rules extends APIResource {
    /**
     * Create email scanner rule
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dlp/email/rules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update email scanner rule
     */
    update(ruleId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/email/rules/${ruleId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all email scanner rules for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dlp/email/rules`, RuleListResponsesSinglePage, options);
    }
    /**
     * Delete email scanner rule
     */
    delete(ruleId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dlp/email/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update email scanner rule priorities
     */
    bulkEdit(params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/dlp/email/rules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get an email scanner rule
     */
    get(ruleId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/email/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class RuleListResponsesSinglePage extends SinglePage {
}
Rules.RuleListResponsesSinglePage = RuleListResponsesSinglePage;
//# sourceMappingURL=rules.mjs.map