// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Entries extends APIResource {
    /**
     * Creates a DLP custom entry.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dlp/entries`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a DLP entry.
     */
    update(entryId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/entries/${entryId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all DLP entries in an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/dlp/entries`, EntryListResponsesSinglePage, options);
    }
    /**
     * Deletes a DLP custom entry.
     */
    delete(entryId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dlp/entries/${entryId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a DLP entry by ID
     */
    get(entryId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/entries/${entryId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class EntryListResponsesSinglePage extends SinglePage {
}
Entries.EntryListResponsesSinglePage = EntryListResponsesSinglePage;
//# sourceMappingURL=entries.mjs.map