"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Custom = void 0;
const resource_1 = require("../../../../resource.js");
class Custom extends resource_1.APIResource {
    /**
     * Creates a DLP custom profile.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/dlp/profiles/custom`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a DLP custom profile.
     */
    update(profileId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/profiles/custom/${profileId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a DLP custom profile.
     */
    delete(profileId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/dlp/profiles/custom/${profileId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a custom DLP profile by id.
     */
    get(profileId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/profiles/custom/${profileId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Custom = Custom;
//# sourceMappingURL=custom.js.map