"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Predefined = void 0;
const resource_1 = require("../../../../resource.js");
class Predefined extends resource_1.APIResource {
    /**
     * Updates a DLP predefined profile. Only supports enabling/disabling entries.
     */
    update(profileId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/profiles/predefined/${profileId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a predefined DLP profile by id.
     */
    get(profileId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/profiles/predefined/${profileId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Predefined = Predefined;
//# sourceMappingURL=predefined.js.map