// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
export class Predefined extends APIResource {
    /**
     * Updates a DLP predefined profile. Only supports enabling/disabling entries.
     */
    update(profileId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/dlp/profiles/predefined/${profileId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a predefined DLP profile by id.
     */
    get(profileId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/dlp/profiles/predefined/${profileId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=predefined.mjs.map