"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateListResponsesSinglePage = exports.Certificates = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Certificates extends resource_1.APIResource {
    /**
     * Creates a new Zero Trust certificate.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/certificates`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches all Zero Trust certificates for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/certificates`, CertificateListResponsesSinglePage, options);
    }
    /**
     * Deletes a gateway-managed Zero Trust certificate. A certificate must be
     * deactivated from the edge (inactive) before it is deleted.
     */
    delete(certificateId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/gateway/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Binds a single Zero Trust certificate to the edge.
     */
    activate(certificateId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/certificates/${certificateId}/activate`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Unbinds a single Zero Trust certificate from the edge
     */
    deactivate(certificateId, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/certificates/${certificateId}/deactivate`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Zero Trust certificate.
     */
    get(certificateId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/certificates/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Certificates = Certificates;
class CertificateListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.CertificateListResponsesSinglePage = CertificateListResponsesSinglePage;
Certificates.CertificateListResponsesSinglePage = CertificateListResponsesSinglePage;
//# sourceMappingURL=certificates.js.map