"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemListResponsesSinglePage = exports.Items = void 0;
const resource_1 = require("../../../../resource.js");
const pagination_1 = require("../../../../pagination.js");
class Items extends resource_1.APIResource {
    /**
     * Fetches all items in a single Zero Trust list.
     */
    list(listId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/lists/${listId}/items`, ItemListResponsesSinglePage, options);
    }
}
exports.Items = Items;
class ItemListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.ItemListResponsesSinglePage = ItemListResponsesSinglePage;
Items.ItemListResponsesSinglePage = ItemListResponsesSinglePage;
//# sourceMappingURL=items.js.map