// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as ItemsAPI from "./items.mjs";
import { ItemListResponsesSinglePage, Items } from "./items.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Lists extends APIResource {
    constructor() {
        super(...arguments);
        this.items = new ItemsAPI.Items(this._client);
    }
    /**
     * Creates a new Zero Trust list.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/lists`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured Zero Trust list. Skips updating list items if not included
     * in the payload.
     */
    update(listId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/gateway/lists/${listId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches all Zero Trust lists for an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/lists`, GatewayListsSinglePage, {
            query,
            ...options,
        });
    }
    /**
     * Deletes a Zero Trust list.
     */
    delete(listId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/gateway/lists/${listId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Appends or removes an item from a configured Zero Trust list.
     */
    edit(listId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/gateway/lists/${listId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Zero Trust list.
     */
    get(listId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/lists/${listId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class GatewayListsSinglePage extends SinglePage {
}
Lists.GatewayListsSinglePage = GatewayListsSinglePage;
Lists.Items = Items;
Lists.ItemListResponsesSinglePage = ItemListResponsesSinglePage;
//# sourceMappingURL=lists.mjs.map