"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocationsSinglePage = exports.Locations = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Locations extends resource_1.APIResource {
    /**
     * Creates a new Zero Trust Gateway location.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/locations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured Zero Trust Gateway location.
     */
    update(locationId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/gateway/locations/${locationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches Zero Trust Gateway locations for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/locations`, LocationsSinglePage, options);
    }
    /**
     * Deletes a configured Zero Trust Gateway location.
     */
    delete(locationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/gateway/locations/${locationId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Zero Trust Gateway location.
     */
    get(locationId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/locations/${locationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Locations = Locations;
class LocationsSinglePage extends pagination_1.SinglePage {
}
exports.LocationsSinglePage = LocationsSinglePage;
Locations.LocationsSinglePage = LocationsSinglePage;
//# sourceMappingURL=locations.js.map