import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Logging extends APIResource {
    /**
     * Updates logging settings for the current Zero Trust account.
     */
    update(params: LoggingUpdateParams, options?: Core.RequestOptions): Core.APIPromise<LoggingSetting>;
    /**
     * Fetches the current logging settings for Zero Trust account.
     */
    get(params: LoggingGetParams, options?: Core.RequestOptions): Core.APIPromise<LoggingSetting>;
}
export interface LoggingSetting {
    /**
     * Redact personally identifiable information from activity logging (PII fields
     * are: source IP, user email, user ID, device ID, URL, referrer, user agent).
     */
    redact_pii?: boolean;
    /**
     * Logging settings by rule type.
     */
    settings_by_rule_type?: LoggingSetting.SettingsByRuleType;
}
export declare namespace LoggingSetting {
    /**
     * Logging settings by rule type.
     */
    interface SettingsByRuleType {
        /**
         * Logging settings for DNS firewall.
         */
        dns?: unknown;
        /**
         * Logging settings for HTTP/HTTPS firewall.
         */
        http?: unknown;
        /**
         * Logging settings for Network firewall.
         */
        l4?: unknown;
    }
}
export interface LoggingUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: Redact personally identifiable information from activity logging
     * (PII fields are: source IP, user email, user ID, device ID, URL, referrer, user
     * agent).
     */
    redact_pii?: boolean;
    /**
     * Body param: Logging settings by rule type.
     */
    settings_by_rule_type?: LoggingUpdateParams.SettingsByRuleType;
}
export declare namespace LoggingUpdateParams {
    /**
     * Logging settings by rule type.
     */
    interface SettingsByRuleType {
        /**
         * Logging settings for DNS firewall.
         */
        dns?: unknown;
        /**
         * Logging settings for HTTP/HTTPS firewall.
         */
        http?: unknown;
        /**
         * Logging settings for Network firewall.
         */
        l4?: unknown;
    }
}
export interface LoggingGetParams {
    account_id: string;
}
export declare namespace Logging {
    export { type LoggingSetting as LoggingSetting, type LoggingUpdateParams as LoggingUpdateParams, type LoggingGetParams as LoggingGetParams, };
}
//# sourceMappingURL=logging.d.ts.map