"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logging = void 0;
const resource_1 = require("../../../resource.js");
class Logging extends resource_1.APIResource {
    /**
     * Updates logging settings for the current Zero Trust account.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/gateway/logging`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the current logging settings for Zero Trust account.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/logging`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Logging = Logging;
//# sourceMappingURL=logging.js.map