// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class ProxyEndpoints extends APIResource {
    /**
     * Creates a new Zero Trust Gateway proxy endpoint.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/proxy_endpoints`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches all Zero Trust Gateway proxy endpoints for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/proxy_endpoints`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a configured Zero Trust Gateway proxy endpoint.
     */
    delete(proxyEndpointId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/gateway/proxy_endpoints/${proxyEndpointId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured Zero Trust Gateway proxy endpoint.
     */
    edit(proxyEndpointId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/gateway/proxy_endpoints/${proxyEndpointId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Zero Trust Gateway proxy endpoint.
     */
    get(proxyEndpointId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/proxy_endpoints/${proxyEndpointId}`, ProxyEndpointsSinglePage, options);
    }
}
export class ProxyEndpointsSinglePage extends SinglePage {
}
ProxyEndpoints.ProxyEndpointsSinglePage = ProxyEndpointsSinglePage;
//# sourceMappingURL=proxy-endpoints.mjs.map