// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Rules extends APIResource {
    /**
     * Creates a new Zero Trust Gateway rule.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/gateway/rules`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured Zero Trust Gateway rule.
     */
    update(ruleId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/gateway/rules/${ruleId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the Zero Trust Gateway rules for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/gateway/rules`, GatewayRulesSinglePage, options);
    }
    /**
     * Deletes a Zero Trust Gateway rule.
     */
    delete(ruleId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/gateway/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Zero Trust Gateway rule.
     */
    get(ruleId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/gateway/rules/${ruleId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Resets the expiration of a Zero Trust Gateway Rule if its duration has elapsed
     * and it has a default duration.
     *
     * The Zero Trust Gateway Rule must have values for both `expiration.expires_at`
     * and `expiration.duration`.
     */
    resetExpiration(ruleId, params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/gateway/rules/${ruleId}/reset_expiration`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class GatewayRulesSinglePage extends SinglePage {
}
Rules.GatewayRulesSinglePage = GatewayRulesSinglePage;
//# sourceMappingURL=rules.mjs.map