import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
import * as GroupsAPI from "../../access/groups.js";
import { ZeroTrustGroupsSinglePage } from "../../access/groups.js";
export declare class Groups extends APIResource {
    /**
     * Lists SCIM Group resources synced to Cloudflare via the System for Cross-domain
     * Identity Management (SCIM).
     */
    list(identityProviderId: string, params: GroupListParams, options?: Core.RequestOptions): Core.PagePromise<ZeroTrustGroupsSinglePage, GroupsAPI.ZeroTrustGroup>;
}
export interface GroupListParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param: The unique Cloudflare-generated Id of the SCIM Group resource; also
     * known as the "Id".
     */
    cf_resource_id?: string;
    /**
     * Query param: The IdP-generated Id of the SCIM Group resource; also known as the
     * "external Id".
     */
    idp_resource_id?: string;
    /**
     * Query param: The display name of the SCIM Group resource.
     */
    name?: string;
}
export declare namespace Groups {
    export { type GroupListParams as GroupListParams };
}
export { ZeroTrustGroupsSinglePage };
//# sourceMappingURL=groups.d.ts.map