// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { ZeroTrustGroupsSinglePage } from "../../access/groups.mjs";
export class Groups extends APIResource {
    /**
     * Lists SCIM Group resources synced to Cloudflare via the System for Cross-domain
     * Identity Management (SCIM).
     */
    list(identityProviderId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/identity_providers/${identityProviderId}/scim/groups`, ZeroTrustGroupsSinglePage, { query, ...options });
    }
}
export { ZeroTrustGroupsSinglePage };
//# sourceMappingURL=groups.mjs.map