// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { AccessUsersSinglePage } from "../../access/users/users.mjs";
export class Users extends APIResource {
    /**
     * Lists SCIM User resources synced to Cloudflare via the System for Cross-domain
     * Identity Management (SCIM).
     */
    list(identityProviderId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/identity_providers/${identityProviderId}/scim/users`, AccessUsersSinglePage, { query, ...options });
    }
}
export { AccessUsersSinglePage };
//# sourceMappingURL=users.mjs.map