import { APIResource } from "../../../resource.js";
import * as VirtualNetworksAPI from "./virtual-networks.js";
import { VirtualNetwork, VirtualNetworkCreateParams, VirtualNetworkDeleteParams, VirtualNetworkEditParams, VirtualNetworkGetParams, VirtualNetworkListParams, VirtualNetworks, VirtualNetworksSinglePage } from "./virtual-networks.js";
import * as RoutesAPI from "./routes/routes.js";
import { NetworkRoute, Route, RouteCreateParams, RouteDeleteParams, RouteEditParams, RouteGetParams, RouteListParams, Routes, Teamnet, TeamnetsV4PagePaginationArray } from "./routes/routes.js";
import * as SubnetsAPI from "./subnets/subnets.js";
import { SubnetListParams, SubnetListResponse, SubnetListResponsesV4PagePaginationArray, Subnets } from "./subnets/subnets.js";
export declare class Networks extends APIResource {
    routes: RoutesAPI.Routes;
    virtualNetworks: VirtualNetworksAPI.VirtualNetworks;
    subnets: SubnetsAPI.Subnets;
}
export declare namespace Networks {
    export { Routes as Routes, type NetworkRoute as NetworkRoute, type Route as Route, type Teamnet as Teamnet, TeamnetsV4PagePaginationArray as TeamnetsV4PagePaginationArray, type RouteCreateParams as RouteCreateParams, type RouteListParams as RouteListParams, type RouteDeleteParams as RouteDeleteParams, type RouteEditParams as RouteEditParams, type RouteGetParams as RouteGetParams, };
    export { VirtualNetworks as VirtualNetworks, type VirtualNetwork as VirtualNetwork, VirtualNetworksSinglePage as VirtualNetworksSinglePage, type VirtualNetworkCreateParams as VirtualNetworkCreateParams, type VirtualNetworkListParams as VirtualNetworkListParams, type VirtualNetworkDeleteParams as VirtualNetworkDeleteParams, type VirtualNetworkEditParams as VirtualNetworkEditParams, type VirtualNetworkGetParams as VirtualNetworkGetParams, };
    export { Subnets as Subnets, type SubnetListResponse as SubnetListResponse, SubnetListResponsesV4PagePaginationArray as SubnetListResponsesV4PagePaginationArray, type SubnetListParams as SubnetListParams, };
}
//# sourceMappingURL=networks.d.ts.map