// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as IPsAPI from "./ips.mjs";
import { IPs } from "./ips.mjs";
import * as NetworksAPI from "./networks.mjs";
import { Networks } from "./networks.mjs";
import { V4PagePaginationArray } from "../../../../pagination.mjs";
export class Routes extends APIResource {
    constructor() {
        super(...arguments);
        this.ips = new IPsAPI.IPs(this._client);
        this.networks = new NetworksAPI.Networks(this._client);
    }
    /**
     * Routes a private network through a Cloudflare Tunnel.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/teamnet/routes`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and filters private network routes in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/teamnet/routes`, TeamnetsV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Deletes a private network route from an account.
     */
    delete(routeId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/teamnet/routes/${routeId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing private network route in an account. The fields that are
     * meant to be updated should be provided in the body of the request.
     */
    edit(routeId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/teamnet/routes/${routeId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a private network route in an account.
     */
    get(routeId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/teamnet/routes/${routeId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class TeamnetsV4PagePaginationArray extends V4PagePaginationArray {
}
Routes.TeamnetsV4PagePaginationArray = TeamnetsV4PagePaginationArray;
Routes.IPs = IPs;
Routes.Networks = Networks;
//# sourceMappingURL=routes.mjs.map