// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as CloudflareSourceAPI from "./cloudflare-source.mjs";
import { CloudflareSource, } from "./cloudflare-source.mjs";
import { V4PagePaginationArray } from "../../../../pagination.mjs";
export class Subnets extends APIResource {
    constructor() {
        super(...arguments);
        this.cloudflareSource = new CloudflareSourceAPI.CloudflareSource(this._client);
    }
    /**
     * Lists and filters subnets in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/zerotrust/subnets`, SubnetListResponsesV4PagePaginationArray, { query, ...options });
    }
}
export class SubnetListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
Subnets.SubnetListResponsesV4PagePaginationArray = SubnetListResponsesV4PagePaginationArray;
Subnets.CloudflareSource = CloudflareSource;
//# sourceMappingURL=subnets.mjs.map