"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNetworksSinglePage = exports.VirtualNetworks = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class VirtualNetworks extends resource_1.APIResource {
    /**
     * Adds a new virtual network to an account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/teamnet/virtual_networks`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and filters virtual networks in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/teamnet/virtual_networks`, VirtualNetworksSinglePage, { query, ...options });
    }
    /**
     * Deletes an existing virtual network.
     */
    delete(virtualNetworkId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing virtual network.
     */
    edit(virtualNetworkId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a virtual network.
     */
    get(virtualNetworkId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.VirtualNetworks = VirtualNetworks;
class VirtualNetworksSinglePage extends pagination_1.SinglePage {
}
exports.VirtualNetworksSinglePage = VirtualNetworksSinglePage;
VirtualNetworks.VirtualNetworksSinglePage = VirtualNetworksSinglePage;
//# sourceMappingURL=virtual-networks.js.map