// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class VirtualNetworks extends APIResource {
    /**
     * Adds a new virtual network to an account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/teamnet/virtual_networks`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and filters virtual networks in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/teamnet/virtual_networks`, VirtualNetworksSinglePage, { query, ...options });
    }
    /**
     * Deletes an existing virtual network.
     */
    delete(virtualNetworkId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing virtual network.
     */
    edit(virtualNetworkId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a virtual network.
     */
    get(virtualNetworkId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/teamnet/virtual_networks/${virtualNetworkId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class VirtualNetworksSinglePage extends SinglePage {
}
VirtualNetworks.VirtualNetworksSinglePage = VirtualNetworksSinglePage;
//# sourceMappingURL=virtual-networks.mjs.map