// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as ReferencesAPI from "./references.mjs";
import { References } from "./references.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Integrations extends APIResource {
    constructor() {
        super(...arguments);
        this.references = new ReferencesAPI.References(this._client);
    }
    /**
     * Create new risk score integration.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/zt_risk_scoring/integrations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Overwrite the reference_id, tenant_url, and active values with the ones provided
     */
    update(integrationId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/zt_risk_scoring/integrations/${integrationId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all risk score integrations for the account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/zt_risk_scoring/integrations`, IntegrationListResponsesSinglePage, options);
    }
    /**
     * Delete a risk score integration.
     */
    delete(integrationId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/zt_risk_scoring/integrations/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get risk score integration by id.
     */
    get(integrationId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/zt_risk_scoring/integrations/${integrationId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class IntegrationListResponsesSinglePage extends SinglePage {
}
Integrations.IntegrationListResponsesSinglePage = IntegrationListResponsesSinglePage;
Integrations.References = References;
//# sourceMappingURL=integrations.mjs.map