import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import { SinglePage } from "../../pagination.js";
export declare class Seats extends APIResource {
    /**
     * Removes a user from a Zero Trust seat when both `access_seat` and `gateway_seat`
     * are set to false.
     */
    edit(params: SeatEditParams, options?: Core.RequestOptions): Core.PagePromise<SeatsSinglePage, Seat>;
}
export declare class SeatsSinglePage extends SinglePage<Seat> {
}
export interface Seat {
    /**
     * True if the seat is part of Access.
     */
    access_seat?: boolean;
    created_at?: string;
    /**
     * True if the seat is part of Gateway.
     */
    gateway_seat?: boolean;
    /**
     * The unique API identifier for the Zero Trust seat.
     */
    seat_uid?: string;
    updated_at?: string;
}
export interface SeatEditParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<SeatEditParams.Body>;
}
export declare namespace SeatEditParams {
    interface Body {
        /**
         * True if the seat is part of Access.
         */
        access_seat: boolean;
        /**
         * True if the seat is part of Gateway.
         */
        gateway_seat: boolean;
        /**
         * The unique API identifier for the Zero Trust seat.
         */
        seat_uid: string;
    }
}
export declare namespace Seats {
    export { type Seat as Seat, SeatsSinglePage as SeatsSinglePage, type SeatEditParams as SeatEditParams };
}
//# sourceMappingURL=seats.d.ts.map