// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Seats extends APIResource {
    /**
     * Removes a user from a Zero Trust seat when both `access_seat` and `gateway_seat`
     * are set to false.
     */
    edit(params, options) {
        const { account_id, body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/seats`, SeatsSinglePage, {
            body: body,
            method: 'patch',
            ...options,
        });
    }
}
export class SeatsSinglePage extends SinglePage {
}
Seats.SeatsSinglePage = SeatsSinglePage;
//# sourceMappingURL=seats.mjs.map