"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Configurations = void 0;
const resource_1 = require("../../../../resource.js");
class Configurations extends resource_1.APIResource {
    /**
     * Adds or updates the configuration for a remotely-managed tunnel.
     */
    update(tunnelId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/cfd_tunnel/${tunnelId}/configurations`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets the configuration for a remotely-managed tunnel
     */
    get(tunnelId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/cfd_tunnel/${tunnelId}/configurations`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Configurations = Configurations;
//# sourceMappingURL=configurations.js.map