import { APIResource } from "../../../../resource.js";
import * as Core from "../../../../core.js";
import * as ConnectionsAPI from "./connections.js";
export declare class Connectors extends APIResource {
    /**
     * Fetches connector and connection details for a Cloudflare Tunnel.
     */
    get(tunnelId: string, connectorId: string, params: ConnectorGetParams, options?: Core.RequestOptions): Core.APIPromise<ConnectionsAPI.Client>;
}
export interface ConnectorGetParams {
    /**
     * Cloudflare account ID
     */
    account_id: string;
}
export declare namespace Connectors {
    export { type ConnectorGetParams as ConnectorGetParams };
}
//# sourceMappingURL=connectors.d.ts.map