"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Management = void 0;
const resource_1 = require("../../../../resource.js");
class Management extends resource_1.APIResource {
    /**
     * Gets a management token used to access the management resources (i.e. Streaming
     * Logs) of a tunnel.
     */
    create(tunnelId, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/cfd_tunnel/${tunnelId}/management`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Management = Management;
//# sourceMappingURL=management.js.map