"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WARPConnectorListResponsesV4PagePaginationArray = exports.WARPConnector = void 0;
const resource_1 = require("../../../../resource.js");
const TokenAPI = __importStar(require("./token.js"));
const token_1 = require("./token.js");
const pagination_1 = require("../../../../pagination.js");
class WARPConnector extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.token = new TokenAPI.Token(this._client);
    }
    /**
     * Creates a new Warp Connector Tunnel in an account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/warp_connector`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and filters Warp Connector Tunnels in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/warp_connector`, WARPConnectorListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes a Warp Connector Tunnel from an account.
     */
    delete(tunnelId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/warp_connector/${tunnelId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing Warp Connector Tunnel.
     */
    edit(tunnelId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/warp_connector/${tunnelId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Warp Connector Tunnel.
     */
    get(tunnelId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/warp_connector/${tunnelId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.WARPConnector = WARPConnector;
class WARPConnectorListResponsesV4PagePaginationArray extends pagination_1.V4PagePaginationArray {
}
exports.WARPConnectorListResponsesV4PagePaginationArray = WARPConnectorListResponsesV4PagePaginationArray;
WARPConnector.WARPConnectorListResponsesV4PagePaginationArray =
    WARPConnectorListResponsesV4PagePaginationArray;
WARPConnector.Token = token_1.Token;
//# sourceMappingURL=warp-connector.js.map