// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as TokenAPI from "./token.mjs";
import { Token } from "./token.mjs";
import { V4PagePaginationArray } from "../../../../pagination.mjs";
export class WARPConnector extends APIResource {
    constructor() {
        super(...arguments);
        this.token = new TokenAPI.Token(this._client);
    }
    /**
     * Creates a new Warp Connector Tunnel in an account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/warp_connector`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and filters Warp Connector Tunnels in an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/warp_connector`, WARPConnectorListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Deletes a Warp Connector Tunnel from an account.
     */
    delete(tunnelId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/warp_connector/${tunnelId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates an existing Warp Connector Tunnel.
     */
    edit(tunnelId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/warp_connector/${tunnelId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Warp Connector Tunnel.
     */
    get(tunnelId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/warp_connector/${tunnelId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class WARPConnectorListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
WARPConnector.WARPConnectorListResponsesV4PagePaginationArray =
    WARPConnectorListResponsesV4PagePaginationArray;
WARPConnector.Token = Token;
//# sourceMappingURL=warp-connector.mjs.map