import { APIResource } from "../../resource.js";
import * as ConnectivitySettingsAPI from "./connectivity-settings.js";
import { ConnectivitySettingEditParams, ConnectivitySettingEditResponse, ConnectivitySettingGetParams, ConnectivitySettingGetResponse, ConnectivitySettings } from "./connectivity-settings.js";
import * as SeatsAPI from "./seats.js";
import { Seat, SeatEditParams, Seats, SeatsSinglePage } from "./seats.js";
import * as AccessAPI from "./access/access.js";
import { Access } from "./access/access.js";
import * as DevicesAPI from "./devices/devices.js";
import { Device, DeviceGetParams, DeviceGetResponse, DeviceListParams, Devices, DevicesSinglePage } from "./devices/devices.js";
import * as DEXAPI from "./dex/dex.js";
import { DEX, DigitalExperienceMonitor, NetworkPath, NetworkPathResponse, Percentiles } from "./dex/dex.js";
import * as DLPAPI from "./dlp/dlp.js";
import { DLP } from "./dlp/dlp.js";
import * as GatewayAPI from "./gateway/gateway.js";
import { Gateway, GatewayCreateParams, GatewayCreateResponse, GatewayListParams, GatewayListResponse } from "./gateway/gateway.js";
import * as IdentityProvidersAPI from "./identity-providers/identity-providers.js";
import { AzureAD, GenericOAuthConfig, IdentityProvider, IdentityProviderCreateParams, IdentityProviderDeleteParams, IdentityProviderDeleteResponse, IdentityProviderGetParams, IdentityProviderListParams, IdentityProviderListResponse, IdentityProviderListResponsesSinglePage, IdentityProviderSCIMConfig, IdentityProviderType, IdentityProviderUpdateParams, IdentityProviders } from "./identity-providers/identity-providers.js";
import * as NetworksAPI from "./networks/networks.js";
import { Networks } from "./networks/networks.js";
import * as OrganizationsAPI from "./organizations/organizations.js";
import { LoginDesign, Organization, OrganizationCreateParams, OrganizationListParams, OrganizationRevokeUsersParams, OrganizationRevokeUsersResponse, OrganizationUpdateParams, Organizations } from "./organizations/organizations.js";
import * as RiskScoringAPI from "./risk-scoring/risk-scoring.js";
import { RiskScoring, RiskScoringGetParams, RiskScoringGetResponse, RiskScoringResetParams, RiskScoringResetResponse } from "./risk-scoring/risk-scoring.js";
import * as TunnelsAPI from "./tunnels/tunnels.js";
import { Connection, TunnelListParams, TunnelListResponse, TunnelListResponsesV4PagePaginationArray, Tunnels } from "./tunnels/tunnels.js";
export declare class ZeroTrust extends APIResource {
    devices: DevicesAPI.Devices;
    identityProviders: IdentityProvidersAPI.IdentityProviders;
    organizations: OrganizationsAPI.Organizations;
    seats: SeatsAPI.Seats;
    access: AccessAPI.Access;
    dex: DEXAPI.DEX;
    tunnels: TunnelsAPI.Tunnels;
    connectivitySettings: ConnectivitySettingsAPI.ConnectivitySettings;
    dlp: DLPAPI.DLP;
    gateway: GatewayAPI.Gateway;
    networks: NetworksAPI.Networks;
    riskScoring: RiskScoringAPI.RiskScoring;
}
export declare namespace ZeroTrust {
    export { Devices as Devices, type Device as Device, type DeviceGetResponse as DeviceGetResponse, DevicesSinglePage as DevicesSinglePage, type DeviceListParams as DeviceListParams, type DeviceGetParams as DeviceGetParams, };
    export { IdentityProviders as IdentityProviders, type AzureAD as AzureAD, type GenericOAuthConfig as GenericOAuthConfig, type IdentityProvider as IdentityProvider, type IdentityProviderSCIMConfig as IdentityProviderSCIMConfig, type IdentityProviderType as IdentityProviderType, type IdentityProviderListResponse as IdentityProviderListResponse, type IdentityProviderDeleteResponse as IdentityProviderDeleteResponse, IdentityProviderListResponsesSinglePage as IdentityProviderListResponsesSinglePage, type IdentityProviderCreateParams as IdentityProviderCreateParams, type IdentityProviderUpdateParams as IdentityProviderUpdateParams, type IdentityProviderListParams as IdentityProviderListParams, type IdentityProviderDeleteParams as IdentityProviderDeleteParams, type IdentityProviderGetParams as IdentityProviderGetParams, };
    export { Organizations as Organizations, type LoginDesign as LoginDesign, type Organization as Organization, type OrganizationRevokeUsersResponse as OrganizationRevokeUsersResponse, type OrganizationCreateParams as OrganizationCreateParams, type OrganizationUpdateParams as OrganizationUpdateParams, type OrganizationListParams as OrganizationListParams, type OrganizationRevokeUsersParams as OrganizationRevokeUsersParams, };
    export { Seats as Seats, type Seat as Seat, SeatsSinglePage as SeatsSinglePage, type SeatEditParams as SeatEditParams, };
    export { Access as Access };
    export { DEX as DEX, type DigitalExperienceMonitor as DigitalExperienceMonitor, type NetworkPath as NetworkPath, type NetworkPathResponse as NetworkPathResponse, type Percentiles as Percentiles, };
    export { Tunnels as Tunnels, type Connection as Connection, type TunnelListResponse as TunnelListResponse, TunnelListResponsesV4PagePaginationArray as TunnelListResponsesV4PagePaginationArray, type TunnelListParams as TunnelListParams, };
    export { ConnectivitySettings as ConnectivitySettings, type ConnectivitySettingEditResponse as ConnectivitySettingEditResponse, type ConnectivitySettingGetResponse as ConnectivitySettingGetResponse, type ConnectivitySettingEditParams as ConnectivitySettingEditParams, type ConnectivitySettingGetParams as ConnectivitySettingGetParams, };
    export { DLP as DLP };
    export { Gateway as Gateway, type GatewayCreateResponse as GatewayCreateResponse, type GatewayListResponse as GatewayListResponse, type GatewayCreateParams as GatewayCreateParams, type GatewayListParams as GatewayListParams, };
    export { Networks as Networks };
    export { RiskScoring as RiskScoring, type RiskScoringGetResponse as RiskScoringGetResponse, type RiskScoringResetResponse as RiskScoringResetResponse, type RiskScoringGetParams as RiskScoringGetParams, type RiskScoringResetParams as RiskScoringResetParams, };
}
//# sourceMappingURL=zero-trust.d.ts.map