// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import * as ConnectivitySettingsAPI from "./connectivity-settings.mjs";
import { ConnectivitySettings, } from "./connectivity-settings.mjs";
import * as SeatsAPI from "./seats.mjs";
import { Seats, SeatsSinglePage } from "./seats.mjs";
import * as AccessAPI from "./access/access.mjs";
import { Access } from "./access/access.mjs";
import * as DevicesAPI from "./devices/devices.mjs";
import { Devices, DevicesSinglePage, } from "./devices/devices.mjs";
import * as DEXAPI from "./dex/dex.mjs";
import { DEX } from "./dex/dex.mjs";
import * as DLPAPI from "./dlp/dlp.mjs";
import { DLP } from "./dlp/dlp.mjs";
import * as GatewayAPI from "./gateway/gateway.mjs";
import { Gateway, } from "./gateway/gateway.mjs";
import * as IdentityProvidersAPI from "./identity-providers/identity-providers.mjs";
import { IdentityProviderListResponsesSinglePage, IdentityProviders, } from "./identity-providers/identity-providers.mjs";
import * as NetworksAPI from "./networks/networks.mjs";
import { Networks } from "./networks/networks.mjs";
import * as OrganizationsAPI from "./organizations/organizations.mjs";
import { Organizations, } from "./organizations/organizations.mjs";
import * as RiskScoringAPI from "./risk-scoring/risk-scoring.mjs";
import { RiskScoring, } from "./risk-scoring/risk-scoring.mjs";
import * as TunnelsAPI from "./tunnels/tunnels.mjs";
import { TunnelListResponsesV4PagePaginationArray, Tunnels, } from "./tunnels/tunnels.mjs";
export class ZeroTrust extends APIResource {
    constructor() {
        super(...arguments);
        this.devices = new DevicesAPI.Devices(this._client);
        this.identityProviders = new IdentityProvidersAPI.IdentityProviders(this._client);
        this.organizations = new OrganizationsAPI.Organizations(this._client);
        this.seats = new SeatsAPI.Seats(this._client);
        this.access = new AccessAPI.Access(this._client);
        this.dex = new DEXAPI.DEX(this._client);
        this.tunnels = new TunnelsAPI.Tunnels(this._client);
        this.connectivitySettings = new ConnectivitySettingsAPI.ConnectivitySettings(this._client);
        this.dlp = new DLPAPI.DLP(this._client);
        this.gateway = new GatewayAPI.Gateway(this._client);
        this.networks = new NetworksAPI.Networks(this._client);
        this.riskScoring = new RiskScoringAPI.RiskScoring(this._client);
    }
}
ZeroTrust.Devices = Devices;
ZeroTrust.DevicesSinglePage = DevicesSinglePage;
ZeroTrust.IdentityProviders = IdentityProviders;
ZeroTrust.IdentityProviderListResponsesSinglePage = IdentityProviderListResponsesSinglePage;
ZeroTrust.Organizations = Organizations;
ZeroTrust.Seats = Seats;
ZeroTrust.SeatsSinglePage = SeatsSinglePage;
ZeroTrust.Access = Access;
ZeroTrust.DEX = DEX;
ZeroTrust.Tunnels = Tunnels;
ZeroTrust.TunnelListResponsesV4PagePaginationArray = TunnelListResponsesV4PagePaginationArray;
ZeroTrust.ConnectivitySettings = ConnectivitySettings;
ZeroTrust.DLP = DLP;
ZeroTrust.Gateway = Gateway;
ZeroTrust.Networks = Networks;
ZeroTrust.RiskScoring = RiskScoring;
//# sourceMappingURL=zero-trust.mjs.map