// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Holds extends APIResource {
    /**
     * Enforce a zone hold on the zone, blocking the creation and activation of zones
     * with this zone's hostname.
     */
    create(params, options) {
        const { zone_id, include_subdomains } = params;
        return this._client.post(`/zones/${zone_id}/hold`, {
            query: { include_subdomains },
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Stop enforcement of a zone hold on the zone, permanently or temporarily,
     * allowing the creation and activation of zones with this zone's hostname.
     */
    delete(params, options) {
        const { zone_id, hold_after } = params;
        return this._client.delete(`/zones/${zone_id}/hold`, {
            query: { hold_after },
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update the `hold_after` and/or `include_subdomains` values on an existing zone
     * hold. The hold is enabled if the `hold_after` date-time value is in the past.
     */
    edit(params, options) {
        const { zone_id, ...body } = params;
        return this._client.patch(`/zones/${zone_id}/hold`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Retrieve whether the zone is subject to a zone hold, and metadata about the
     * hold.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/hold`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=holds.mjs.map